### **Definition of VPN**

- **RFC 2828 Definition**:
    
    - A VPN is "a restricted-use, logical computer network constructed from the system resources of a relatively public, physical network (e.g., the Internet)."
    - Commonly uses encryption and tunneling to link virtual networks across real networks.
- **Characteristics**:
    
    - **Virtual**: Logical networks, independent of physical architecture.
    - **Private**: Ensures privacy through:
        - **Noncryptographic approach**: Independent of IP addressing and routing.
        - **Cryptographic approach**: Provides confidentiality, integrity, and authentication.
    - **Network**: Interconnected systems designed to share information.
- **Traffic Flow**:
    
    - Carries private traffic over public/shared infrastructure like the internet.
    - Often applied at the **network layer** of the OSI model:
        - Encrypts traffic among specific users, apps, or subnets.
        - Transparent to intermediate network devices and independent of topology.
- **Secure VPNs**:
    
    - Examples: **IPsec** and **TLS/DTLS**.
    - Protect against threats like man-in-the-middle attacks.

---

### **Benefits of VPNs**

1. **Cost Savings**:
    
    - Use cost-effective internet transport instead of expensive dedicated WAN links.
    - Leverage high-bandwidth technologies to reduce connectivity costs while increasing bandwidth.
2. **Scalability**:
    
    - Easily add new users using the internet infrastructure of ISPs.
    - Scale capacity without significant infrastructure changes.
3. **Compatibility with Broadband**:
    
    - Enables remote workers to use high-speed broadband for corporate network access.
    - Offers flexibility, efficiency, and cost-effective solutions for remote office connections.
4. **Security**:
    
    - Provides advanced encryption and authentication protocols for data protection.

---

### **VPN Use Cases**

Focuses on VPNs that ensure privacy through cryptographic approaches.

#### **1. Enterprise Internet Edge**

- **Definition**:
    
    - Acts as the gateway between the enterprise and cyberspace.
    - Services include DMZ, corporate internet access, and VPN.
- **Functions**:
    
    - **Remote Access VPN**:
        - Safely connects mobile users to enterprise services (email, messaging, etc.) over the internet.
        - Accommodates centralized internet and cloud service access via headquarters if policies require.
    - **Site-to-Site VPN**:
        - Connects remote branches over the internet.
        - Reduces costs associated with dedicated WAN links or provides redundancy.
- **Cisco Devices Used**:
    
    - Cisco Secure Firewall ASA.
    - Cisco Secure Firewall Threat Defense.
    - Cisco Secure Client (for mobile users).

---

#### **2. Enterprise WAN**

- **Definition**:
    
    - Aggregates WAN links connecting distant branch offices to central or regional hub sites.
    - WANs are commonly provided by service providers.
- **Functions**:
    
    - Enables branches to securely access services similar to campus users.
    - Supports multiple WAN clouds for redundancy or load balancing.
    - Can use internet connections as secondary backups.
- **Cisco Devices Used**:
    
    - Cisco Secure Firewall ASA.
    - Cisco Secure Firewall Threat Defense.
    - Cisco IOS XE routers.

---

#### **3. Enterprise Branch**

- **Definition**:
    
    - Connects users and devices at remote locations via LAN and WAN or internet connections.
- **Functions**:
    
    - Accommodates one or two WAN clouds with backup internet connections.
    - Allows either direct internet access or centralized internet access via headquarters (based on access policies).
- **Cisco Devices Used**:
    
    - Cisco Secure Firewall ASA.
    - Cisco Secure Firewall Threat Defense.
    - Cisco IOS XE routers.